#!/usr/bin/perl

# Redhive: Peep Traffic Monitor
# pedram amini <pedram@redhive.com, http://pedram.redhive.com>
#

use strict;
use Net::Peep::BC;
use Net::Peep::Log;
use Net::Peep::Client;
$|++;

my %C = ();
my ($conf, $destination, $direction, $service, $source);

# set the print flag.
my $print_flag = 1;

my $logger = new Net::Peep::Log;
my $client = new Net::Peep::Client;

# take care of some peep requirements.
$client->name('traffic_monitor');
$client->initialize() || $client->pods();
$client->parser(\&parse);
$conf = $client->configure();

# the tcpdump filter. we're looking for only the start of the following types of
# connections (filtering for SYN flag) and DNS traffic.
my $filter = "dst port 21 or 22 or 25 or 80 or 110 or 443 and tcp[13] & 2 != 0 "
           . "or udp dst port 53";

# start tcpdump. we don't need timestampes (-t). -nn prevents dns lookups and
# /etc/service lookups for ports. -q suppresses some other output we don't need.
# -l turns on line buffering, without it our script doesn't get any output.
# oh yes, i also redirect errors from tcpdump since it likes to print to STDERR.
open (TCPDUMP, "tcpdump '$filter' -nn -t -i eth0 -q -l 2> /dev/null |");

# main loop.
while (<TCPDUMP>)   {
    # remove newline.
    chomp;

    # extract the information we're interested in.
    ($direction, $source, undef, $destination, undef) = split / /, $_, 5;

    # strip the ':' from destination.
    chop($destination);

    # extract the service port type from destination.
    (undef, undef, undef, undef, $service) = split /\./, $destination, 5;

    if ($print_flag)    {
        $logger->log("$direction $source $destination - $C{$service}\n");
    }

    # setup our event message.
    my $broadcast = Net::Peep::BC->new('traffic_monitor', $conf);

    # send the event to the server.
    $broadcast->send('traffic_monitor',
          type=>0,
          sound=>$C{$service},
          location=>128,
          priority=>0,
          volume=>255);
}


################################################################################
# parse
# parses configuration settings from peep.conf
#
sub parse {
    # service         event
    # 21              tm-ftp
    # 22              tm-ssh
    # ...
    for my $line (@_)   {
        $C{$1} = $2 if ( $line =~ /^\s*(\d+)\s+(tm\-\w+)/ );
    }
}