#!/usr/bin/perl

#
# /proc/net/dev rrd collector
#

$print_flag = shift;

@devs = `cat /proc/net/dev`;

for ($i = 3; $i <= $#devs; $i++) {
    $_ = $devs[$i];
    
    chomp;

    s/^\s+//;                   # remove leading whitespace.
    s/\s+$//;                   # remove trailing whitespace.
    s/\s\s/ /g while (/\s\s/);  # remove all double spaces.
    s/:/ /;                     # replace "eth0:" with "eth0 ".

    @eth0 = split / / if (/eth0/);
    @eth1 = split / / if (/eth1/);
    @eth2 = split / / if (/eth2/);
}

# [1]   :   Rx bytes
# [2]   :   Rx packets
# [9]   :   Tx bytes
# [10]  :   Tx packets

if ($print_flag)    {
    print "rrdtool update /rrd/eth0.rrd N:$eth0[1]:$eth0[9]\n";
    print "rrdtool update /rrd/eth1.rrd N:$eth1[1]:$eth1[9]\n";
    print "rrdtool update /rrd/eth2.rrd N:$eth2[1]:$eth2[9]\n";
}

`rrdtool update /rrd/eth0.rrd N:$eth0[1]:$eth0[9]`;
`rrdtool update /rrd/eth1.rrd N:$eth1[1]:$eth1[9]`;
`rrdtool update /rrd/eth2.rrd N:$eth2[1]:$eth2[9]`;