#!/bin/bash

###
# cron.daily script
# recreates daily, weekly, monthly, yearly, and decade temperature graphs.
# rrd database location: /rrd/
# rrd graph location:    /www/html/rrdgraphs/


rrdtool graph /www/html/rrdgraphs/temperature_daily.gif                  \
        --title "resolution: daily"                                      \
        --width 600                                                      \
        --color BACK#333333                                              \
        --color SHADEA#000000                                            \
        --color SHADEB#000000                                            \
        --color CANVAS#000000                                            \
        --color GRID#999999                                              \
        --color MGRID#666666                                             \
        --color FONT#CCCCCC                                              \
        --color FRAME#333333                                             \
        --start -86400                                                   \
        --vertical-label "fahrenheit"                                    \
        --no-legend                                                      \
        DEF:inside=/rrd/inside_temperature.rrd:temperature:AVERAGE       \
        DEF:outside=/rrd/outside_temperature.rrd:temperature:AVERAGE     \
        LINE1:inside#00FF00:inside                                       \
        LINE1:outside#FF0000:outside

rrdtool graph /www/html/rrdgraphs/temperature_weekly.gif                 \
        --title "resolution: weekly"                                     \
        --width 600                                                     \
        --color BACK#333333                                              \
        --color SHADEA#000000                                            \
        --color SHADEB#000000                                            \
        --color CANVAS#000000                                            \
        --color GRID#999999                                              \
        --color MGRID#666666                                             \
        --color FONT#CCCCCC                                              \
        --color FRAME#333333                                             \
        --start -604800                                                  \
        --vertical-label "fahrenheit"                                    \
        --no-legend                                                      \
        DEF:inside=/rrd/inside_temperature.rrd:temperature:AVERAGE       \
        DEF:outside=/rrd/outside_temperature.rrd:temperature:AVERAGE     \
        LINE1:inside#00FF00:inside                                       \
        LINE1:outside#FF0000:outside

rrdtool graph /www/html/rrdgraphs/temperature_monthly.gif                \
        --title "resolution: monthly"                                    \
        --width 600                                                     \
        --color BACK#333333                                              \
        --color SHADEA#000000                                            \
        --color SHADEB#000000                                            \
        --color CANVAS#000000                                            \
        --color GRID#999999                                              \
        --color MGRID#666666                                             \
        --color FONT#CCCCCC                                              \
        --color FRAME#333333                                             \
        --start -2419200                                                 \
        --vertical-label "fahrenheit"                                    \
        --no-legend                                                      \
        DEF:inside=/rrd/inside_temperature.rrd:temperature:AVERAGE       \
        DEF:outside=/rrd/outside_temperature.rrd:temperature:AVERAGE     \
        LINE1:inside#00FF00:inside                                       \
        LINE1:outside#FF0000:outside

#rrdtool graph /www/html/rrdgraphs/temperature_yearly.gif                 \
#        --title "resolution: yearly"                                     \
#        --width 600                                                     \
#        --color BACK#333333                                              \
#        --color SHADEA#000000                                            \
#        --color SHADEB#000000                                            \
#        --color CANVAS#000000                                            \
#        --color GRID#999999                                              \
#        --color MGRID#666666                                             \
#        --color FONT#CCCCCC                                              \
#        --color FRAME#333333                                             \
#        --start -29030400                                                \
#        --vertical-label "fahrenheit"                                    \
#        --no-legend                                                      \
#        DEF:inside=/rrd/inside_temperature.rrd:temperature:AVERAGE       \
#        DEF:outside=/rrd/outside_temperature.rrd:temperature:AVERAGE     \
#        LINE1:inside#00FF00:inside                                       \
#        LINE1:outside#FF0000:outside

#rrdtool graph /www/html/rrdgraphs/temperature_decade.gif                 \
#        --title "resolution: decade"                                     \
#        --width 600                                                     \
#        --color BACK#333333                                              \
#        --color SHADEA#000000                                            \
#        --color SHADEB#000000                                            \
#        --color CANVAS#000000                                            \
#        --color GRID#999999                                              \
#        --color MGRID#666666                                             \
#        --color FONT#CCCCCC                                              \
#        --color FRAME#333333                                             \
#        --start -290304000                                               \
#        --vertical-label "fahrenheit"                                    \
#        --no-legend                                                      \
#        DEF:inside=/rrd/inside_temperature.rrd:temperature:AVERAGE       \
#        DEF:outside=/rrd/outside_temperature.rrd:temperature:AVERAGE     \
#        LINE1:inside#00FF00:inside                                       \
#        LINE1:outside#FF0000:outside