#!/bin/bash

###
# cron.daily script
# recreates daily net device graphs.
# rrd database location: /rrd/
# rrd graph location:    /www/html/rrdgraphs/


rrdtool graph /www/html/rrdgraphs/ethx_daily.gif   \
        --title "todays traffic"             \
        --width 600                         \
        --color BACK#333333                  \
        --color SHADEA#000000                \
        --color SHADEB#000000                \
        --color CANVAS#000000                \
        --color GRID#999999                  \
        --color MGRID#666666                 \
        --color FONT#CCCCCC                  \
        --color FRAME#333333                 \
        --start -86400                       \
        --vertical-label "bytes/sec"         \
        --no-legend                          \
        DEF:myrx0=/rrd/eth0.rrd:rx:AVERAGE   \
        DEF:mytx0=/rrd/eth0.rrd:tx:AVERAGE   \
        DEF:myrx1=/rrd/eth1.rrd:rx:AVERAGE   \
        DEF:mytx1=/rrd/eth1.rrd:tx:AVERAGE   \
        DEF:myrx2=/rrd/eth2.rrd:rx:AVERAGE   \
        DEF:mytx2=/rrd/eth2.rrd:tx:AVERAGE   \
        CDEF:rx=myrx0,myrx1,myrx2,+,+        \
        CDEF:tx=mytx0,mytx1,mytx2,+,+        \
        LINE1:rx#00FF00:Rx                   \
        LINE1:tx#FF0000:Tx

rrdtool graph /www/html/rrdgraphs/eth0_daily.gif   \
        --title "todays extranet traffic"    \
        --width 600                         \
        --color BACK#333333                  \
        --color SHADEA#000000                \
        --color SHADEB#000000                \
        --color CANVAS#000000                \
        --color GRID#999999                  \
        --color MGRID#666666                 \
        --color FONT#CCCCCC                  \
        --color FRAME#333333                 \
        --start -86400                       \
        --vertical-label "bytes/sec"         \
        --no-legend                          \
        DEF:myrx=/rrd/eth0.rrd:rx:AVERAGE    \
        DEF:mytx=/rrd/eth0.rrd:tx:AVERAGE    \
        LINE1:myrx#00FF00:Rx                 \
        LINE1:mytx#FF0000:Tx
        
rrdtool graph /www/html/rrdgraphs/eth1_daily.gif   \
        --title "todays intranet traffic"    \
        --width 600                         \
        --color BACK#333333                  \
        --color SHADEA#000000                \
        --color SHADEB#000000                \
        --color CANVAS#000000                \
        --color GRID#999999                  \
        --color MGRID#666666                 \
        --color FONT#CCCCCC                  \
        --color FRAME#333333                 \
        --start -86400                       \
        --vertical-label "bytes/sec"         \
        --no-legend                          \
        DEF:myrx=/rrd/eth1.rrd:rx:AVERAGE    \
        DEF:mytx=/rrd/eth1.rrd:tx:AVERAGE    \
        LINE1:myrx#00FF00:Rx                 \
        LINE1:mytx#FF0000:Tx
        
rrdtool graph /www/html/rrdgraphs/eth2_daily.gif   \
        --title "todays wireless traffic"    \
        --width 600                         \
        --color BACK#333333                  \
        --color SHADEA#000000                \
        --color SHADEB#000000                \
        --color CANVAS#000000                \
        --color GRID#999999                  \
        --color MGRID#666666                 \
        --color FONT#CCCCCC                  \
        --color FRAME#333333                 \
        --start -86400                       \
        --vertical-label "bytes/sec"         \
        --no-legend                          \
        DEF:myrx=/rrd/eth2.rrd:rx:AVERAGE    \
        DEF:mytx=/rrd/eth2.rrd:tx:AVERAGE    \
        LINE1:myrx#00FF00:Rx                 \
        LINE1:mytx#FF0000:Tx
