###############################################################################
# pedbot_command_list
#
# synopsis:  provides a simple list of all available commands.
# arguments: none.
# returns:   command list.

$COMMANDS{list} = "provides a simply list of all available commands.";

sub pedbot_command_list {
    my $from     = shift;
    
    # initialize the message.
    my $command_list = "";
    
    # step through the command list.
    foreach my $key (sort keys %COMMANDS) {
        if (!pedbot_validate_admin($from) && $COMMANDS{$key} =~ /admin only/) {
            next;
        }
        
        # add command to command list.
        $command_list .= "$key, ";
    }
    
    # chop off the trailing seperator ', ' from the command list.
    chop($command_list);
    chop($command_list);
    
    return $command_list;
}1;