###############################################################################
# pedbot_command_help
#
# synopsis:  online help system. can provide general help or command specific
#            help and syntax.
# arguments: command (optional).
# returns:   help message.

$COMMANDS{help} = "[command] provides help on a specific command or on all "
                . "commands if no argument is specified.";

sub pedbot_command_help {
    my $from     = shift;
    my $command  = lc(shift);
    
    if ($command && $COMMANDS{$command}) {
        return "<b>$command</b>: $COMMANDS{$command}\n";
    }
    
    my $message = "<b>pedbot command list</b>\n"
                . "<i>all commands begin with a . (dot)</i>\n"
                . "<i>to repeat the last command simply send one . (dot)</i>\n";
    
    foreach my $key (sort keys %COMMANDS) {
        if (!pedbot_validate_admin($from) && $COMMANDS{$key} =~ /admin only/) {
            next;
        }
        
        $message .= "<b>.$key</b>: $COMMANDS{$key}\n";
    }
    
    return $message;
}1;