###############################################################################
# pedbot_command_areacode
#
# synopsis:  returns the location associated with a telephone area code.
# arguments: area code.
# returns:   area code location

$COMMANDS{areacode} = "<area code> returns the geographic location associated "
                    . "with an area code.";

sub pedbot_command_areacode {
    my $from      = shift;
    my $area_code = shift;
    
    if ( !$area_code ) {
        return "no area code provided.";
    }
    
    if ( $area_code =~ /\d\d\d\d\d/) {
        return "area code not zip code.";
    }

    my $sql_query = "SELECT * FROM area_codes WHERE area_code = $area_code";
    my $dbquery   = $dbhandle->prepare($sql_query);
                    $dbquery->execute;

    my $result = $dbquery->fetchrow_hashref;
    
    if ( !$result->{area_code} ) {
        return "i don't know anything about $area_code." 
    }
    
    return $result->{description};
}1;