###############################################################################
# pedbot_on_im_in
#
# synopsis:  this routine is called whenever a message is received.
# arguments: 
# returns:   none

sub pedbot_on_im_in {
    my $aim  = shift;
    my $evt  = shift;
    my $from = shift;
    my $to   = shift;
    my $args = $evt->args();
    my ($nick, $friend, $msg) = @$args;
    my $reply;
   
    $msg  = pedbot_filter_html($msg);

    ##
    ## if a command was received pass it over to the command handler.
    ##
    if ($msg =~ /^\.(\w*)\s*(.*)/ && $msg !~ /^\.\.*$/ && $msg ne ".") {
        $command = $1;
        @args = split / /, $2;

        pedbot_command($aim, $from, $command, @args);
        pedbot_log_command($from, $command, @args);
        
        $statistics{commands}++;
    }


    ##
    ## if the command is a simple . (dot) then we repeat the last command.
    ##    
    elsif ($msg eq ".") {
        my $sql_query = "SELECT command, arguments FROM log_commands WHERE "
                      . "sender = '$from' ORDER BY timestamp DESC LIMIT 0, 1";
        
        my $dbquery   = $dbhandle->prepare($sql_query);
        
        $dbquery->execute;
        
        my $result = $dbquery->fetchrow_hashref;
        
        $dbquery->finish;
        
        $command = $result->{command};
        @args    = split / /, $result->{arguments};
        
        pedbot_command($aim, $from, $command, @args);
        pedbot_log_command($from, $command, @args);
        
        $statistics{commands}++;
    }
    
    ##
    ## otherwise create an intelligent response, filter it and reply.
    ##
    else {
        pedbot_log("$from: $msg");
        pedbot_log_conversation($from, $to, $msg);
        
        # XXX - we need to put a switch here between alice and eliza.
        # XXX - the current filtering method via command line manipulation
        #       is definetely an area that requires scrutiny for security holes.
        #       pedbot_filter_command() is responsible for converting tainted
        #       characters into safe ones.
        
        $reply = $eliza->transform($msg);
        #$reply = pedbot_ask_alice($aim->normalize($from), $msg);
        
        $reply = pedbot_filter_command($reply);
        $reply = `echo $reply | $C{FILTER} 2>/dev/null`;
        
        chomp($reply);
        
        # XXX - sleeping here pauses the whole program which means that during
        #       busy times people have to wait for a long time.
        
        pedbot_sleep($C{SLEEP_RANGE});
        
        pedbot_send_im($aim, $from, $C{CHAT_FONT}, $reply);
        
        pedbot_log("$C{SCREENNAME} -> $from: $reply");
        pedbot_log_conversation($to, $from, $reply);
        
        $statistics{messages}++;
    }
}1;