###############################################################################
# pedbot_send_im
#
# synopsis:  this routine is pedbot's send_aim() wrapper. it splits the message
#            into chucks that will fit AIM's window constraints and send them
#            all one by one.
# arguments: aim pointer, from, font, message.
# returns:   none.

sub pedbot_send_im {
    my $aim     = shift;
    my $from    = shift;
    my $font    = shift;
    my $message = shift;
    
    # maximum number of characters we can send at a time.
    my $aim_max = $C{AIM_MAX};
    
    my $cut_pos;
    
    # split the message into chunks of size < aim_max but try to break them on
    # a newline or a space. if that is not possible then just break it at max.
    while (length($message) >= $aim_max) {
        $cut_pos = rindex($message, "\n", $aim_max);
        $cut_pos = rindex($message, " ",  $aim_max) if ($cut_pos < 0);
        $cut_pos = $aim_max                         if ($cut_pos < 0);

        $aim->send_im($from, "<$font>" . substr($message, 0, $cut_pos));

        $message = substr($message, $cut_pos, length($message));
        
        # we sleep to prevent exceeding the speed limit (ie: flooding).
        # XXX - play with this timing to see what is ideal.
        #       may have to use a finer sleep with select().
        sleep 1;
    }
    
    
    
    # send out the last chunk.
    $aim->send_im($from, "<$font>" . $message);
    
}1;