###############################################################################
# pedbot_command_zip_dist
#
# synopsis:  finds the distance in miles between two zip codes.
# arguments: zip1, zip2
# returns:   distance.

$COMMANDS{zip_dist} = "<zip1> <zip2> finds the distance in miles between two "
                    . "zip codes.";

sub pedbot_command_zip_dist {
    my $from  = shift;
    my $zip1  = shift;
    my $zip2  = shift;
    
    return "two zip codes are required as arguments.\n" if (!$zip1 || !$zip2);
    
    # sanity checking. make sure the zip codes are only numbers.
    return "1st zip contains invalid characters: $zip1." if ($zip1 =~ /[^\d]/);
    return "2nd zip contains invalid characters: $zip2." if ($zip2 =~ /[^\d]/);
    
    my $pi = 3.1415926535898;
    my $radius_of_earth = 3956;

    my ($dbquery, $result, $sql_query);
    my ($lat1, $lat2, $lon1, $lon2);
    
    # grab the latitude / longitude coordinates of the zip codes.
    $sql_query = "SELECT *FROM zip_locations WHERE zipcode = $zip1"
               . "                              OR zipcode = $zip2";
    
    $dbquery = $dbhandle->prepare($sql_query);
    $dbquery->execute;

    # return an error if either one of the zip codes don't exist in our db.
    if ( $dbquery->rows != 2 ) {
        $result = $dbquery->fetchrow_hashref;
        
        return "$zip1 not found." if ( $result->{zipcode} == $zip2 );
        return "$zip2 not found." if ( $result->{zipcode} == $zip1 );
        return "neither zip code found.";
    }
    
    # store the latitude / longitude coordinates of the zip codes.
    while ($result = $dbquery->fetchrow_hashref) {
        if ($result->{zipcode} == $zip1) {
            $lat1 = $result->{lat};
            $lon1 = $result->{lon};
        }
        if ($result->{zipcode} == $zip2) {
            $lat2 = $result->{lat};
            $lon2 = $result->{lon};
        }
    }
    
    $dbquery->finish;

    # convert to radians.
    $lat1 = $lat1 * $pi / 180.0;
    $lat2 = $lat2 * $pi / 180.0;
    $lon1 = $lon1 * $pi / 180.0;
    $lon2 = $lon2 * $pi / 180.0;

    # determine the distances in radians.
    my $delta_lat = $lat1 - $lat2;
    my $delta_lon = $lon1 - $lon2;

    # determine the circular distance.    
    my $cd = sin($delta_lat / 2.0)**2 + 
             cos($lat1) * cos($lat2) * sin($delta_lon / 2.0)**2;
       
    # determine the actual difference.
    my $distance = $radius_of_earth * 2 * 
                   atan2( sqrt( abs($cd) ), sqrt( abs(1 - $cd) ) );

    # round the distane to 2 decimal places.
    $distance = sprintf("%.2f", $distance);
                   
    return "distance between $zip1 and $zip2: $distance miles";
}1;