###############################################################################
# pedbot_command_weather
#
# synopsis:  provides the current weather status at the specified location
#            through information gathered from weather.com
# arguments: zip code.
# returns:   weather information.

$COMMANDS{weather} = "<zip code> provides current weather report.";

sub pedbot_command_weather {
    my $from     = shift;
    my $zip_code = shift;
    
    my ($temperature, $forecast, $uv_index, $wind, $dew_point, $humidity, 
        $visibility, $barometer);

    return "zip code required"           if (!defined($zip_code));
    return "invalid zip code: $zip_code" if ($zip_code !~ /\d\d\d\d\d/);

    my @data = pedbot_get_url("www.weather.com", "/weather/local/$zip_code");
    
    for (my $i = 0; $i <= $#data; $i++) {
        $_ = $data[$i];

        if (/insert current temp/)   {
            $temperature = pedbot_filter_html($_);
            $temperature =~ s/&nbsp;/ /g;
            $temperature =~ s/&deg;//g;
        }

        if (/insert forecast text/)   {
            $forecast = pedbot_filter_html($_);
            $forecast =~ s/&nbsp;/ /g;
        }

        if (/insert UV number/)   {
            $uv_index = pedbot_filter_html($_);
            $uv_index =~ s/&nbsp;/ /g;
        }
        
        if (/insert wind information/)   {
            $wind = pedbot_filter_html($_);
            $wind =~ s/&nbsp;/ /g;
        }
        
        if (/insert dew point/)   {
            $dew_point = pedbot_filter_html($_);
            $dew_point =~ s/&nbsp;/ /g;
            $dew_point =~ s/&deg;//g;
        }
        
        if (/insert humidity/)   {
            $humidity = pedbot_filter_html($_);
            $humidity =~ s/&nbsp;/ /g;
        }
        
        if (/insert visibility/)   {
            $visibility = pedbot_filter_html($_);
            $visibility =~ s/&nbsp;/ /g;
        }
        
        if (/insert barometer information/)   {
            $barometer = pedbot_filter_html($_);
            $barometer =~ s/&nbsp;/ /g;
        }
    }
    
    if ( !$temperature || !$forecast   || !$uv_index || !$wind || !$dew_point ||
         !$humidity    || !$visibility || !$barometer ) {
            return "unable to retrive weather information";
    }
    
    return "\n<b>weather report for $zip_code</b>\n"
         . "<b>temperature</b>: $temperature\n"
         . "<b>forecast</b>:     $forecast\n"
         . "<b>uv index</b>:     $uv_index\n"
         . "<b>wind</b>:         $wind\n"
         . "<b>dew point</b>:    $dew_point\n"
         . "<b>humidity</b>:     $humidity\n"
         . "<b>visibility</b>:   $visibility\n"
         . "<b>barometer</b>:    $barometer\n";
}1;