###############################################################################
# pedbot_command_top_ten
#
# synopsis:  displays pedbot's about message.
# arguments: none.
# returns:   about message.

$COMMANDS{top_ten} = "display the top ten most popular commands.";

sub pedbot_command_top_ten {
    my $from = shift;
    
    my ($dbquery, $result, $rs, $sqlquery, $total_count);
    
    $sql_query = "SELECT COUNT(*) AS mycount FROM log_commands";
    
    $dbquery = $dbhandle->prepare($sql_query);
    $dbquery->execute;
    
    $result = $dbquery->fetchrow_hashref;
    
    $total_count = $result->{mycount};
    
    $dbquery->finish;
    
    # although we're only showing the top ten we don't use a limit here because
    # some of those top ten may be admin only commands that we don't want to
    # display.
    $sql_query = "SELECT DISTINCT(command), COUNT(id) AS mycount FROM "
                  . "log_commands GROUP BY command ORDER BY mycount DESC";
    
    $dbquery = $dbhandle->prepare($sql_query);
    $dbquery->execute;
    
    $rs = "<b>top ten most popular commands</b> (and the % of total):\n";
    
    for (my $i = 0; $i < 10; ) {
        $result = $dbquery->fetchrow_hashref;
        
        # make sure the command exists.
        next if (!$COMMANDS{$result->{command}});
        
        # don't count admin only commands.
        next if ($COMMANDS{$result->{command}} =~ /admin only/);
        
        # increment the count.
        $i++;
        
        $percent = sprintf("%.3f", $result->{mycount} / $total_count * 100);
        
        $rs .= pedbot_swrite(<<'END', $result->{command}, "%$percent\n");
@<<<<<<<<<<<<<< @>>>>>>>>
END
        #$rs .= sprintf("%20s (%%%.3f)\n",
        #            $result->{command},
        #            $result->{mycount} / $total_count * 100);
    }

    $dbquery->finish;
    
    return $rs;
}1;