###############################################################################
# pedbot_command_ipmap
#
# synopsis:  prints the city, state, and lat/long coordinates of the ip address.
#            we gather this information from caida's netgeo service. we also
#            provide links to microsoft terraserver and mapquest.
# arguments: ip address.
# returns:   geographical information.

$COMMANDS{ipmap} = "<ip address> prints the city, state, and lat/long "
                 . "coordinates of the ip address.";

sub pedbot_command_ipmap {
    my $from       = shift;
    my $ip_address = shift;
    
    return "ip address required" if ( !defined($ip_address) );
    
    # resolve the ip address in case the user provided a name.
    my $packed  = gethostbyname($ip_address);
    return "could not resolve $ip_address" if (!$packed);
    $ip_address = inet_ntoa($packed);
    
    # create the url and grab the data.
    my $url  = "/perl/netgeo.cgi?target=$ip_address";
    my @data = pedbot_get_url("netgeo.caida.org", $url);
    
    my $return_string = "geographical information for: <b>$ip_address</b>\n";
    
    my ($lat, $lon);
    
    # step through the returned data and parse out the information we need.
    for (my $i = 0; $i <= $#data; $i++) {
        my ($key, $value) = split / /, $data[$i], 2;
        
        $value =~ s/^\s+// if ($value);   # remove leading whitespace.
        $value =~ s/\s+$// if ($value);   # remove trailing whitespace.        
        
        $lat  = $value if ($key eq "LAT:");
        $long = $value if ($key eq "LONG:");
        
        $return_string .= "<b>city</b>:    $value\n" if ($key eq "CITY:");
        $return_string .= "<b>state</b>:   $value\n" if ($key eq "STATE:");
        $return_string .= "<b>country</b>: $value\n" if ($key eq "COUNTRY:");
        $return_string .= "<b>lat</b>:     $value\n" if ($key eq "LAT:");
        $return_string .= "<b>long</b>:    $value\n" if ($key eq "LONG:");
    }       
    
    $lat  =~ s/<br>//;
    $long =~ s/<br>//;
    
    # create the microsoft terraserver link.
    my $terra_server_link = "http://terraserver.microsoft.com/image.asp?Lat="
                          . "$lat&Lon=$long&W=2";
    
    # create the mapquest link.
    my $mapquest_link     = "http://www.mapquest.com/maps/map.adp?latlongtype="
                          . "decimal&latitude=$lat&longitude=$long";
    
    # add the two links to our return string.
    $return_string .= "<a href=\"$terra_server_link\">"
                   .  "microsoft terraserver map</a><br>";
    $return_string .= "<a href=\"$mapquest_link\">mapquest map</a><br>";
    
    return $return_string;
}1;