###############################################################################
# pedbot_command_define
#
# synopsis:  provides a definition for a given word courtesy of dictionary.com
# arguments: word.
# returns:   definition.

$COMMANDS{define} = "<word> provides a definition for word.";

sub pedbot_command_define {
    my $from = shift;
    my $word = shift;
    
    # sanity checking. make sure word is provided and is just one word
    # containing alphanumeric characters.
    return "a word is required" if (!defined($word));
    return "word contains invalid characters: $word" if ($word !~ /[A-Za-z0-9]+/);

    # construct the target url and fetch the data.
    my $url  = "/cgi-bin/dict.pl?config=wap&term=$word";
    my @data = pedbot_get_url("www.dictionary.com", $url);
    
    my $definition = "";
    my $flag       = 0;
    
    # parse through the data and extract the definition.
    for (my $i = 0; $i <= $#data; $i++) {
        $_ = $data[$i];

        # the definition lies in the line after the following marker.
        if (/resultListStart/) {
            $flag = 1;
            next;
        }
        
        # if the recording flag is set then record the line and break the loop.
        if ($flag) {
            $definition = $_;
            $definition = pedbot_filter_html($definition);
            $definition =~ s/(\d+):/\n$1:/g;
            $i = $#data;
        }
    }
    
    return "<b>definition for $word</b>:\n $definition\n";
}1;