#!/usr/local/bin/perl -w
my $version = "v1.3.3";

#
# Bid Monkey v1.3.3 (does your ebay bidding for you)
#
# pedram amini <pedram@redhive.com> <http://pedram.redhive.com>
#
# synopsis:
#   - connect to internet if we have to.
#   - determine time left on auction.
#   - disconnect from internet.
#   - sleep for most of that time.
#   - reconnect to internet.
#   - re-determine time left on auction.
#   - "review bid".
#   - sleep until the last minute.
#   - place the actual bid.
#
# why do i determine the time left on the auction twice? increased accuracy. let
# me take this opportunity to officially apologize for not fitting this code in
# 80 columns, it just looked too ugly.
#
#
# contributions (alphabetical by last name):
#
#   ulrich gierschner
#       - notified me of ebay changes that broke v1.2.5.
#
#   craig hollabaugh:
#       - pointed out the warnings in ask_interactive in v1.3.1.
#
#   mark kahrs
#       - XHTML regex updates.
#       - sounded the alarm on the broken regex in v1.2.3.
#
#   stefan luethje:
#       - interactive input.
#       - more information for output.
#       - chdir(), so you can execute script without cd-ing to it.
#
#   dietrich rothe
#       - fixed the currency extraction regex (for international).
#       - original addition of get_online / get_offline calls.
#       - measuring of monkey_review_bid delay for increased accuracy.
#
#   marcus schopen
#       - sounded the alarm on the broken regex in v1.2.2.
#       - sounded the alarm on errors that have popped up due to usage of -w.
#       - notified me of ebay changes that broke v1.2.5.
#
#   michael sterrett
#       - exit(0) to make cron happy.
#       - convinced me to start releasing bid_monkey with -w in shabang.
#       - fixed error in sleeping logic.
#       - fixed error in max bid check logic.
#
#   samuel bieri
#       - noticed the 302 message change.
#       - sounded the alarm when 1.3.2 broke.
#
#   steve zilliox
#       - found the price extraction bug in v1.3.0.
#
#
# version 1.3.3 changes
#   - fixed compatibility issues with ebay changes.
#   - added a more verbose "insufficient bid amount" message.
#
# version 1.3.2 changes
#   - fixed warning messages in ask interactive.
#
# version 1.3.1 changes
#   - fixed a bug in price extraction for prices greater then $999.
#   - minor code cleanup.
#
# version 1.3.0 changes
#   - ebay changed their scheme a great deal requiring multiple changes to
#     monkey_determine_auction_end().
#   - added --bid_now option for the immediate placing of bids.
#   - re-ordered output of --help alphabeticaly by long option switch.
#   - minor code re-organiziation.
#
# version 1.2.5 changes
#   - fixed broken regex in price extraction of items with "buy it now".
#   - fixed broken regex in extraction of article name.
#
# version 1.2.4 changes
#   - bid monkey now changes $0 in order to prevent disclosure of authentication
#     information in 'ps' output. while we're changing it we change it to
#     some useful information as well.
#   - fixed broken regex in price extraction.
#
# version 1.2.3 changes
#   - fixed broken regex in price extraction.
#   - removed the double declaration of $currency and $price.
#   - redirect STDOUT to /dev/null when daemonizing.
#
# version 1.2.2 changes
#   - fixed a broken regex in price extraction.
#   - added exit(0) to make cron happy.
#   - fixed error in sleeping logic.
#   - fixed error in max bid check logic.
#   - bid monkey now gets released with -w in shabang.
#
# version 1.2.1 changes
#   - updated a regex to work with ebays new XHTML compatible code.
#
# version 1.2 changes
#   - added all contributions from dietrich rothe.
#   - note: the get[online,offline] scripts are really a unix only thing.
#   - made the necessary changes to input/output interfaces to accomodate for
#     those additions.
#
# version 1.1 changes
#   - fixed problem associated with ebay changing their directory structure.
#   - added code to handle moved objects.
#   - added all contributions from stefan luethje.
#   - some other minor changes i can't remember.
#

use IO::Socket;
use Getopt::Long;
use File::Basename;
use Time::localtime;
use strict;

# change working directory to directory script.
chdir(dirname($0));

# rename $0. we don't want to disclose authentication information on 'ps' output
# at any point. we'll be changing this in the future as well.
$0 = "bid monkey $version";

# monkey ask interactive flags.
my $F_VALUE_INT = 1;

# support files
require 'monkey_functions.pl';

# globals.
my @USER_AGENTS = ();
my $UA_DB       = "db/user_agents.db";

# locals.
my $interactive       = 0;      # --ask
my $bid_now           = 0;      # --bid_now
my $dialup            = 0;      # --dialup
my $dialup_time       = 60;     # --dialup_time
my $help              = 0;      # --help
my $item_num          = 0;      # --item_num
my $max_bid           = 0;      # --max_bid
my $password          = "";     # --password
my $quantity          = 1;      # --quantity
my $safety            = 120;    # --safety
my $username          = "";     # --username
my $price             = 0;
my $currency          = "";

my $time_before_delay = 0;

my ($article, $daemonize, $days, $ebay_key, $headers, $hours, $mins, $secs, $sleep_time, $time, $ua, $until);

#
# parse command line arguments and initialize.
#

print "\n[ bid monkey $version ]\n\n";

GetOptions (
    'ask|a'           => \$interactive,
    'bid_now|n'       => \$bid_now,
    'daemonize|d'     => \$daemonize,
    'dialup|l'        => \$dialup,
    'dialup_time|t=i' => \$dialup_time,
    'help|h'          => \$help,
    'item_num|i=i'    => \$item_num,
    'max_bid|b=s'     => \$max_bid,
    'password|p=s'    => \$password,
    'quantity|q=i'    => \$quantity,
    'safety|s=i'      => \$safety,
    'username|u=s'    => \$username
) || monkey_usage();

# interactive input if item_num and max_bid are not set.
if ($interactive && !$help)
{
    my $defusername = $username;
    $username    = monkey_ask_interactive("ebay user name", $username, 0);
    $password    = monkey_ask_interactive("ebay password", "", 0) if ($password eq "" || $defusername ne $username);
    $item_num    = monkey_ask_interactive("ebay item number", $item_num > 0 ? $item_num : "", $F_VALUE_INT);
    $max_bid     = monkey_ask_interactive("maximum bid amount", $max_bid > 0 ? $max_bid : "", 0);
    $safety      = monkey_ask_interactive("safety time in seconds", $safety, $F_VALUE_INT);
    $dialup      = monkey_ask_interactive("call get_online / get_offline scripts to connect/disconnect from internet (0 for no, or 1 for yes)", $dialup, $F_VALUE_INT);
    $dialup_time = monkey_ask_interactive("time it takes to connect to internet in seconds", $dialup_time, $F_VALUE_INT) if ($dialup);
    print "\n";
}

# we need a connection.
system("./get_online.sh") if ($dialup);

# parse the maximum bid value.
$max_bid = monkey_parse_max_bid($max_bid);

# make sure all the required arguments are set.
monkey_usage() if ($item_num == 0 || $max_bid == 0 || $username eq "" || $password eq "");


if ($daemonize)
{                                   # daemonize if we have to.
    print "daemonizing...\n";       # announce what we're about to do.
    fork && exit;                   # spawn a child and kill the parent.
    close STDOUT;                   # close our inherited file descriptors.
    close STDIN;                    # we keep STDERR open for error messages.
    open  STDOUT, ">/dev/null";     # supress print errors when in daemon mode.
}

# initialize database.
monkey_initialize_db($UA_DB);

# retrieve headers we're going to use.
($ua, $headers) = monkey_get_headers();

print "monkey has decided to spoof the following user agent: $ua\n";

# see how much time is left on the auction.
($days, $hours, $mins, $secs, $currency, $price, $article) = monkey_determine_auction_end($item_num, $headers);

# some sanity checking.
monkey_error("couldn't fetch price information on item number $item_num.") if (!$price);

# print the summary.
print "\nmonkey bid summary:";
print "\n    item number:   $item_num";
print "\n    article:       $article";
print "\n    maximum bid:   $currency $max_bid";
print "\n    current price: $currency $price";
print "\n    username:      $username";
print "\n    password:      $password";
print "\n    dynamically connecting to internet." if ($dialup);
print "\n    time it takes to connect to internet in seconds: $dialup_time." if ($dialup);
print "\n    monkey will place bid at $safety seconds before the end of auction.";
print "\n\n";

# make sure the bid is high enough.
monkey_error("your maximum bid is too low.  bid more than $currency $price.") unless ($price < $max_bid);

print "auction ends in: $days days $hours hours $mins minutes $secs seconds.\n";
print "placing bid immediately.\n" if ($bid_now);

# we shall sleep until the final hour if we aren't asked to bid immediately.
# then awaken to redetermine the remaining time on the auction.
if ($hours > 0 && !$bid_now)
{
    # sleep until the final hour then recalculate auction end time.
    $sleep_time = (3600 * $hours) + (86400 * $days);

    # if we need to dialup take that into effect.
    $sleep_time -= $dialup_time if ($dialup);

    # ensure that we don't sleep right to the end of the auction.
    $sleep_time -= $safety + 60 if ($mins == 0);

    # determine when we're going to sleep to until.
    $time  = localtime(time() + $sleep_time);
    $until = sprintf("%02d/%02d %02d:%02d.%02d", $time->mon + 1,
                                                 $time->mday,
                                                 $time->hour,
                                                 $time->min,
                                                 $time->sec);

    # announce the sleep time on both stdout and through $0.
    print "monkey is going to sleep for: $days days $hours hours, until $until\n";
    $0 = "bid monkey working on #$item_num sleeping until $until";

    # we won't need the connection for a while.
    system("./get_offline.sh") if ($dialup);

    # go to sleep.
    sleep($sleep_time);

    # we need a connection.
    # we no longer drop the connection after this point to get better accuracy.
    system("./get_online.sh") if ($dialup);

    # the final hour has arrived. let us redetermine when the auction ends.
    ($days, $hours, $mins, $secs, $currency, $price) = monkey_determine_auction_end($item_num, $headers);

    print "auction ends in: $days days $hours hours $mins minutes $secs seconds.\n";
}

# store the current time to measure the following procedural delay.
$time_before_delay = time;

# calculate sleep time. (note: hours and days should be zero here).
$sleep_time = $secs + (60 * $mins) + (3600 * $hours) + (86400 * $days) - $safety;

# "review bid" - start bidding process and retrieve ebay key for placing bid.
$ebay_key = monkey_review_bid($item_num, $max_bid, $headers);

# if we don't have the key at this point we need to bail.
monkey_error("key not found") if (!$ebay_key);

# if we're not supposed to bid immediately:
if (!$bid_now)
{
    # determine when we're going to sleep to until.
    $time  = localtime(time() + $sleep_time);
    $until = sprintf("%02d/%02d %02d:%02d.%02d", $time->mon + 1,
                                                 $time->mday,
                                                 $time->hour,
                                                 $time->min,
                                                 $time->sec);

    # announce the sleep time on both stdout and through $0.
    print "monkey is going to sleep for: $mins minutes $secs seconds - $safety seconds, until $until\n";
    $0 = "bid monkey working on #$item_num sleeping until $until";

    # sleep for proper amount of time.
    # take into account the procedural delay.
    # we count the procedural delay twice, once for monkey_review_bid and once more
    # for monkey_place_bid.
    sleep ($sleep_time - 2 * (time - $time_before_delay));
}

# place bid.
monkey_place_bid($item_num, $max_bid, $quantity, $username, $password, $ebay_key, $headers);

print "\nbid placed. check your email for the outcome. give monkey banana.\n";

# we're finished with the connection now.
# modify get_offline.sh to timeout if you get annoyed with bid monkey kicking
# you offline while your working.
system("./get_offline.sh") if ($dialup);

# make cron happy.
exit(0);
