#!/usr/bin/python

#
# Bid Monkey Exception Definitions
#
# pedram amini <pedram@redhive.com> <http://pedram.redhive.com>
#

class monkeyx:
    ############################################################################
    ### exception id (xid) constants.
    ###
    LOAD     = 0
    EXPECTED = 1
    GENERAL  = 2
    PARSING  = 3
    BIDDING  = 4
    SOCKET   = 5


    ############################################################################
    ### constructor
    ###
    ### args: exception id, detailed message.
    ###
    def __init__(self, id, arg):
        self.id  = id
        self.arg = arg


    ############################################################################
    ### print wrapper
    ###
    ### called when printing an exception.
    ###
    ### returns: string containing exception type and error message.
    ###
    def __str__(self):
        if self.id == self.LOAD:     return "load error: "        + self.arg
        if self.id == self.EXPECTED: return "expected variable: " + self.arg
        if self.id == self.GENERAL:  return "general error: "     + self.arg
        if self.id == self.PARSING:  return "parsing error: "     + self.arg
        if self.id == self.BIDDING:  return "bidding error: "     + self.arg
        if self.id == self.SOCKET:   return "socket error: "      + self.arg


    ############################################################################
    ### get_xid()
    ###
    ### returns the exceptions exception id.
    ###
    ### returns: numeric exception id.
    ###
    def get_xid(self):
        return self.id


    ############################################################################
    ### get_xid_const()
    ###
    ### returns the exceptions exception id as a word representing the constant.
    ###
    ### returns: ascii exception id.
    ###
    def get_xid_const(self):
        if self.id == self.LOAD:     return "LOAD"
        if self.id == self.EXPECTED: return "EXPECTED"
        if self.id == self.GENERAL:  return "GENERAL"
        if self.id == self.PARSING:  return "PARSING"
        if self.id == self.BIDDING:  return "BIDDING"
        if self.id == self.SOCKET:   return "SOCKET"
