#!/usr/bin/python

#
# Bid Monkey Command Line / GUI Driver
#
# pedram amini <pedram@redhive.com> <http://pedram.redhive.com>
#

import getopt
import sys
import os

# import bid monkey engine and bid monkey gui classes.
sys.path.append("classes")
from bid_monkey_engine import *
from sniping_engine    import *
from monkeyx           import *


################################################################################
### helper functions
###

def die(message = ""):
    if message:
        print "\nMONKEY-FATAL> " + message

    sys.exit(1)


def go_daemon():
    # we can't daemonize if we are running in win32. we detect if we are in a
    # win32 environment by attempting to access a module routine available only
    # in unix.
    try:    os.getuid()
    except: return

    print "daemonizing..."

    # do first fork.
    try:
        pid = os.fork()
        if pid > 0:
            sys.exit(0)
    except OSError:
        die("fork-1 failed")

    # decouple from parent environment.
    os.chdir("/")
    os.setsid()
    os.umask(0)

    # do second fork.
    try:
        pid = os.fork()
        if pid > 0:
            sys.exit(0)
    except OSError:
        die("fork-2 failed")

    # redirect file descriptors.
    sys.stdin  = open('/dev/null', 'r')
    sys.stdout = open('/dev/null', 'w')
    sys.stderr = open('/dev/null', 'w')


def usage():
    usage  = "Usage: bid_monkey"
    usage += " -i <item #> -m <max bid> -u <username> -p <password> [options]  "
    usage += "\n  --bid_now   | -n  place bid immediately (don't sleep).       "
    usage += "\n  --daemonize | -d  daemonize (run in background, unix only.   "
    usage += "\n  --gui       | -g  start the bid monkey gui.                  "
    usage += "\n  --help      | -h  show this help screen.                     "
    usage += "\n  --item_num  | -i  <item #> item number you wish to bid on.   "
    usage += "\n  --max_bid   | -m  <max bid> maximum amount your willing bid. "
    usage += "\n  --password  | -p  <password> your ebay password.             "
    usage += "\n  --quantity  | -q  <quantity> quantity to bid on (default 1). "
    usage += "\n  --renew     | -r  grab the most up to date patterns database."
    usage += "\n  --safety    | -s  <seconds> safety time (default 2 mins).    "
    usage += "\n  --username  | -u  <username> your ebay username.             "
    usage += "\n"
    usage += "\nif the username or password are not specified, bid monkey will "
    usage += "\nattempt to prompt for them interactively.                      "
    usage += "\n"
    return usage


################################################################################
### main routine
###

# instantiate and initialize a monkey.
u = "databases/user_agents.db"
p = "databases/patterns.db"
c = "databases/cookies.db"

try:            monkey = bid_monkey_engine(u, p, c)
except monkeyx, x: print x, sys.exit(1)

# command line options variables and flags.
bid_now   = False
daemonize = False
gui       = False
help      = False
renew     = False

# command line options.
try:
    opts, args = getopt.getopt(sys.argv[1:], "andghi:m:p:q:rs:u:",
                 [
                    "ask",       "bid_now",   "daemonize", "gui",       "help",
                    "item_num=", "max_bid=",  "password=", "quantity=", "renew",
                    "safety=",   "username="
                 ])
except getopt.GetoptError:
    print usage()
    die()

# parse command line options.
for o, a in opts:
    if o in ("-n", "--bid_now")   : bid_now   = True
    if o in ("-d", "--daemonize") : daemonize = True
    if o in ("-g", "--gui")       : gui       = True
    if o in ("-h", "--help")      : help      = True
    if o in ("-i", "--item_num")  : monkey.set_item_number(a)
    if o in ("-m", "--max_bid")   : monkey.set_max_bid(monkey.parse_max_bid(a))
    if o in ("-p", "--password")  : monkey.set_password(a)
    if o in ("-q", "--quantity")  : monkey.set_quantity(a)
    if o in ("-r", "--renew")     : renew     = True
    if o in ("-s", "--safety")    : monkey.set_safety(a)
    if o in ("-u", "--username")  : monkey.set_username(a)

# if we are using the gui then launch it.
if gui and not help:
    try:    from bid_monkey_gui import *
    except: die("could not start gui")

    bid_monkey_gui(monkey)

    try:    gtk.mainloop()
    except: print "bid monkey gui exiting ..."

    sys.exit(0)

# if we're here it's because we're going to be in command line mode.
# print the banner.
print "\n[ bid monkey v%s ]"    % monkey.get_version()
print "patterns db version: %s" % monkey.get_patterns_ver()
print "%s %s\n" % (monkey.get_author_name(), monkey.get_author_url())

# usage has requested help.
if help:
    print usage()
    die()

# if we have to renew do so and exit.
if renew:
    print "renewing patterns database file: %s ..." % monkey.get_db_patterns(),

    try:               monkey.renew()
    except monkeyx, x: die(x.__str__())

    print "done."
    sys.exit(0)

# check for the required arguments.
if not monkey.get_item_number(): print usage(), die()
if not monkey.get_max_bid()    : print usage(), die()

# if the username and password were not specified ask for them via stdin.
if not monkey.get_username():
    monkey.set_username(raw_input("username> "))
    
    if not monkey.get_username():
        die("failed to read/store username")
    
if not monkey.get_password():
    import getpass
    monkey.set_password(getpass.getpass("password> "))

    if not monkey.get_password():
        die("failed to read/store password")

# ensure the provided credentials are correct.
try:
    print "signing in ... please be patient\n"
    monkey.scrape_sign_in()
except monkeyx, x:
    die(x.__str__())

# daemonize if requested and not in win32 environment.
if daemonize: go_daemon()

# instantiate and initialize a sniping engine.
sniper = sniping_engine(monkey, bid_now)

# snipe the auction.
sniper.snipe()

# make cron happy.
sys.exit(0)
