#!/usr/bin/perl -w

###
###  pedbot v1.1
###
###  pedram amini <pedram@redhive.com, http://pedram.redhive.com>
###
###  contributions:
###    ralph schindler <ralph@snarff.net, http://www.ralphschindler.com>
###      - quotes database.
###      - facts database.
###      - original pronounceable password generation code.
###
###    doug brown      <doug@redhive.com, http://doug.redhive.com>
###      - the rock database.
###      - pickup line generator idea (pointed me to Bone::Easy perlmod).
###
### notes:
###   areas that need work are marked with XXX.
###
### todo:
###   thread send_im() so that we can sleep without affecting rest of program.
###   tie in with alice.
###   work on eliza script.
###   update jive filter.
###   update valspeak filter.
###   security audit.
###   flood prevention in send_im().
###   port jive/valspeak filter to perl.
###   include support for other messaging protocols, perhaps build some kind of
###     abstraction layer.
###   add command to filter text into jive / valspeak.
###   change define to work off of Net::Dict instead of dictionary.com
###     (http://search.cpan.org/doc/NEILB/Net-Dict-2.06/lib/Net/Dict.pod).
###   google interface.
###
###

use Time::localtime;        # used in logging
use Chatbot::Eliza;         # eliza chat engine, you can remove if you use alice
use File::Basename;         # used for determining script base directory
use Bone::Easy;             # used in commands/pickup
use SOAP::Lite;             # used in commands/google*
use IO::Socket;             # used by many commands for retrieving websites
use Net::AIM;               # this module connects our bot to AIM
use DBI;                    # all data is stored in a database
$|++;

###
###  globals.
###

%C               = ();
%statistics      = ();
%alice_sessions  = ();
%blocked_users   = ();
%message_queue   = ();
%online_users    = ();
$aim             = undef;
$dbhandle        = undef;
$eliza           = undef;
$last_sigint     = 0;
$message_dropped = undef;
$start_time      = time;

###
###  seed the random number generator.
###

srand;

###
###  database settings.
###

my $DB_TYPE        = "";         # DB type (mysql)
my $DB_SERVER      = "";         # DB server address
my $DB_PORT        = "";         # DB server port (3306 for mysql)
my $DB_DB          = "";         # DB database
my $DB_USER        = "";         # DB user name
my $DB_PASS        = "";         # DB password

###
###  we do this so we can call the script from anywhere.
###

chdir(dirname($0));

###
###  load required files.
###

my @load_these = ("commands", "functions", "handlers");

while ( my $dir = shift @load_these ) {
    opendir(DIR, $dir) || die "failed to open $dir directory.\n";
    
    my @files = readdir(DIR);
    
    for (my $i = 0; $i <= $#files; $i++) {
        next if $files[$i] !~ /\.pl/;
        require "$dir/$files[$i]";
    }
}

###
###  establish our signal handlers.
###

$SIG{INT}  = \&pedbot_sigint_handler;
$SIG{ALRM} = sub { die "timeout" };

###
###  database connectivity.
###

$dbhandle = DBI->connect("DBI:$DB_TYPE:$DB_DB:$DB_SERVER:$DB_PORT",
                              $DB_USER, $DB_PASS,
                        { RaiseError => 1, AutoCommit => 1 } );

###
###  load configuration options into memory.
###

pedbot_load_conf();

###
###  daemonize if we have to.
###

if ($C{DAEMONIZE}) {
    print "daemonizing...\n";          # announce what we're about to do.
    fork && exit;                      # spawn a child and kill the parent.
    close STDOUT;                      # close our inherited file descriptors.
    close STDIN;
    close STDERR;
}

###
###  create an eliza bot.
###

$eliza = new Chatbot::Eliza {
    name            => $C{SCREENNAME},
#    scriptfile      => "support/pedbot.script",
    debug           => $C{ELIZA_DEBUG},
    max_memory_size => 5000,
};

###
###  AIM connectivity.
###

$aim = new Net::AIM;

$aim->debug(1) if ( $C{AIM_DEBUG} );

$aim->newconn ( Screenname    => $C{SCREENNAME},
                Password      => $C{PASSWORD},
                AutoReconnect => 1
              ) or die "pedbot couldn't connect.\n";

my $conn = $aim->getconn();

###
###  establish the AIM event handlers.
###

$conn->set_handler('chat_in',               \&pedbot_on_chat_in);
$conn->set_handler('chat_invite',           \&pedbot_on_chat_invite);
$conn->set_handler('chat_join',             \&pedbot_on_chat_join);
$conn->set_handler('chat_left',             \&pedbot_on_chat_left);
$conn->set_handler('chat_update_buddy',     \&pedbot_on_chat_update_buddy);
$conn->set_handler('config',                \&pedbot_on_config);
$conn->set_handler('error',                 \&pedbot_on_error);
$conn->set_handler('eviled',                \&pedbot_on_eviled);
$conn->set_handler('goto_url',              \&pedbot_on_goto_url);
$conn->set_handler('im_in',                 \&pedbot_on_im_in);
$conn->set_handler('nick',                  \&pedbot_on_nick);
$conn->set_handler('update_buddy',          \&pedbot_on_update_buddy);

###
###  fall into an infinite loop. 
###  call the scheduler routine on configured interval.
###

my $last_scheduler_run = time;

for (;;) {
    # execute a read off the AIM socket.
    # we set a timeout on this operation so that during inactive periods our
    # scheduler will still get called.
    eval {
        alarm $C{SCHED_INTERVAL};
            $aim->do_one_loop();
        alarm 0;
    };
    
    # call the scheduler routine on the configured interval.
    if (time - $last_scheduler_run >= $C{SCHED_INTERVAL}) {
        pedbot_scheduler() ;
        $last_scheduler_run = time;
    }
}
