###############################################################################
# pedbot_sigint_handler
#
# synopsis:  this routine is our sigint catcher and cleanup function. you have
#            to sigint twice within a 5 second window to actually exit.
# arguments: none.
# returns:   none.

sub pedbot_sigint_handler {
    my $current_time = time;
    
    # if the last sigint did not occur in a 5 second window from now ...
    # print and exit.
    if ($current_time - $last_sigint > 5) {
        $last_sigint = $current_time;
        print "SIGINT caught. Do it again within 5 seconds to exit.\n";
        return;
    }
    
    print "SIGINT caught again. Cleaning up and exiting.\n";
    
    # XXX - add routine to update running configuration options in database.
    
    $dbhandle->disconnect();

    # XXX - suppress complaints about missing handlers.
    close STDOUT;
    close STDERR;

    exit;
}1;