###############################################################################
# pedbot_seconds_2_string
#
# synopsis:  converts seconds to days:hours:mins:secs.
# arguments: seconds.
# returns:   formatted string.

sub pedbot_seconds_2_string {
    use integer;
    
    my $seconds = shift;
    return "$seconds secs" if $seconds < 60;

    my $minutes = $seconds / 60, $seconds %= 60;
    $seconds = "0$seconds"  if $seconds < 10;
    return "$minutes mins $seconds secs" if $minutes < 60;

    my $hours = $minutes / 60, $minutes %= 60;
    $minutes = "0$minutes" if $minutes < 10;
    return "$hours hrs $minutes mins $seconds secs" if $hours < 24;

    my $days = $hours / 24, $hours %= 24;
    $hours  = "0$hours" if $hours < 10;
    return "$days days $hours hrs $minutes mins $seconds secs";
}1;