###############################################################################
# pedbot_get_url
#
# synopsis:  formulate a get request and retrieve data from a url.
# arguments: host, url, port (optional).
# returns:   array holding page contents.

sub pedbot_get_url {
    my $host = shift;
    my $url  = shift;
    my $port = shift;
    
    # default port is 80.
    $port = "80" if ( !defined($port) );

    my (@data, $get_request, $sock);

    # generate the get_request.
    $get_request  = "GET $url HTTP/1.0\r\n"
                  . "User-Agent: pedbot <pedram.redhive.com>\r\n"
                  . "Host: $host\r\n"
                  . "\r\n";

    $sock = IO::Socket::INET->new("$host:$port") || die "\n$!";
    $sock->autoflush(1);

    print $sock $get_request;

    for (my $i = 0; <$sock>; $i++) {
        $data[$i] = $_;
    }

    return @data;
}1;