###############################################################################
# pedbot_debug
#
# synopsis:  prints a debug message if the control flag is set.
# arguments: message to print.
# returns:   none.

sub pedbot_debug {
    my $message = shift;

    return if ($C{DEBUG} == 0);

    # determine timestamp
    $time = localtime(time);

    printf("DEBUG> %02d.%02d.%d %02d:%02d:%02d %s\n", $time->mon + 1,
                                                      $time->mday,
                                                      $time->year + 1900,
                                                      $time->hour,
                                                      $time->min,
                                                      $time->sec,
                                                      $message);
}1;