###############################################################################
# pedbot_command_statistics
#
# synopsis:  step through the %statistics hash returning the values in a nice
#            format to the user.
# arguments: none.
# returns:   statistics.

$COMMANDS{statistics} = "prints the currently running pedbot statistics.";

sub pedbot_command_statistics {
    my $from = shift;
    
    my $count = 0;
    
    # if the user is an administrator then the command count is simply the
    # number of keys in the %COMMANDS hash.
    if (pedbot_validate_admin($from)) {
        $count = scalar keys %COMMANDS;
    }
    
    # if the user is NOT an administrator then we must step through the keys in
    # the %COMMANDS hash and only count those whose value does not contain the
    # string "admin only".
    else {
        foreach my $key (sort keys %COMMANDS) {
            next if ($COMMANDS{$key} =~ /admin only/);
            $count++;
        }
    }
    
    # determine how many messages are awaiting in the queue.
    my $queue_count = 0;
    foreach my $key (sort keys %message_queue) {
        $queue_count += $message_queue{$key};
    }
    
    # give these hash keys a value if it doesn't already have one.
    $statistics{commands} = 0 if (!$statistics{commands});
    $statistics{messages} = 0 if (!$statistics{messages});
    $statistics{pickup}   = 0 if (!$statistics{pickup});

    # determine the running time (current time - start time).
    my $running_time = pedbot_seconds_2_string(time - $start_time);
    
    return "<b>pedbot currently running statistics</b>:\n"
         . "running time:            <b>$running_time</b>\n"
         . "commands received:       <b>$statistics{commands}</b>\n"
         . "messages received:       <b>$statistics{messages}</b>\n"
         . "pickup lines generated:  <b>$statistics{pickup}</b>\n"
         . "available commands:      <b>$count</b>\n"
         . "messages in queue:       <b>$queue_count</b>";
}1;