###############################################################################
# pedbot_command_search
#
# synopsis:  search google for specific terms and return the top five results.
# arguments: terms.
# returns:   top five results.

$COMMANDS{search} = "<terms> search google for terms and return the top "
                         . "five results.";

sub pedbot_command_search {
    my $from = shift;
    my @args = @_;
    
    # sanity checking.
    return "<terms> is a required argument."   if (!$args[0]);

    my ($google, $query, $result, $rs, $title, $url);

    # build the query out of the args array.
    for (my $i = 0; $i <= $#args; $i++) { $query .= "$args[$i] "; }
    
    # from http://groups.yahoo.com/group/soaplite/message/895:
    #     there's a known problem with SOAP::Lite v0.51. boolean type in XML
    #     schema 1999 doesn't accept 'true/false', only '1/0' which is
    #     incorrect.
    # this is the workaround:
    *SOAP::XMLSchema1999::Deserializer::as_boolean    =
    *SOAP::XMLSchemaSOAP1_1::Deserializer::as_boolean =
    \&SOAP::XMLSchema2001::Deserializer::as_boolean;
    
    $google = SOAP::Lite->service("file:support/GoogleSearch.wsdl");
    
    $result = $google->doGoogleSearch($C{GOOGLE_KEY},     # key
                                      $query,             # query
                                      0,                  # start
                                      6,                  # max results (5 + 1)
                                      "false", 
                                      "", 
                                      "false", 
                                      "", 
                                      "latin1", 
                                      "latin1");
                                               
    $rs = "total number of results: $result->{estimatedTotalResultsCount}\n";
    
    for (my $i = 1; $i <= 5; $i++) {
        $title = $result->{resultElements}->[$i]->{title};
        $url   = $result->{resultElements}->[$i]->{URL};
        
        # make sure we have a url before we continue.
        next if (!$url);
        
        # default title if none provided.
        $title = "no title" if (!$title);
        
        # strip the html tags out of the title.
        $title = pedbot_filter_html($title);
        
        # weird how we have to use three newlines here to get two out onto the
        # screen.
        $rs .= "$i.    <b>$title</b>\n"
        .  "url:  $url\n\n\n";
    }
    
    return $rs;
}1;