###############################################################################
# pedbot_command_quote
#
# synopsis:  provides market information on provided symbol from AOL (netscape).
# arguments: symbol.
# returns:   stock quote.

$COMMANDS{quote} = "<symbol> prints a stock quote for provided symbol.";

sub pedbot_command_quote {
    my $from   = shift;
    my $symbol = uc(shift);
    
    return "invalid symbol: $symbol" if ($symbol !~ /\w+/);
    
    my $url  = "?action=aim&fields=snpgflocvAa&syms=$symbol";
    my @data = pedbot_get_url("charts.netscape.com", $url);
    
    # data breakdown.
    # 0:  symbol       : DATA=AAPL;
    # 1:  name         : APPLE COMPUTER INC;
    # 2:  last price   : 24.500000;
    # 3:  change       : -0.060;
    # 4:  date         : 2002/04/08;
    # 5:  low          : 24.410;
    # 6:  open         : 24.590;
    # 7:  high         : 24.560;
    # 8:  volume       : 758400;
    # 9:  52-week high : 27.120;
    # 10: 52-week low  : 14.680
    
    chomp($data[$#data]);
    
    my @quote = split /;/, $data[$#data];
    
    my $font;
    $font = "font color=\"#FF0000\"" if ($quote[3] <  0);
    $font = "font color=\"#000000\"" if ($quote[3] == 0);
    $font = "font color=\"#00FF00\"" if ($quote[3] > 0);
    
    return "\n<b>symbol</b>:          $quote[1], $symbol\n"
         . "<b>price</b>:           $quote[2]\n"
         . "<b>change</b>:         <$font>$quote[3]</font><$C{COMMAND_FONT}>\n"
         . "<b>todays range</b>:   $quote[5] - $quote[7]\n"
         . "<b>volume</b>:          $quote[8]\n"
         . "<b>52 week range</b>:  $quote[10] - $quote[9]";
    
    ###
    ### the commented out code below is for retrieving data from yahoo.com.
    ###
    
    #my $url  = "/d/quotes.csv?s=$symbol&f=sl1d1t1c1ohgv&e=.csv";
    #my @data = pedbot_get_url("quote.yahoo.com", $url);
    
    # "AAPL", 23.67, "3/28/2002", "4:01pm", 0.00, 23.70, 23.88, 23.46, 1936700
    # symbol, price, last trade, last tradetime, change, open, high, low, volume
    #   0       1        2             3            4     5     6     7     8
    #my @quote = split /,/, $data[$#data];
    
    #return "<b>symbol</b>:  $symbol\n"
    #     . "<b>price</b>:   $quote[1]\n"
    #     . "<b>change</b>:  $quote[4]\n"
    #     . "<b>low</b>:     $quote[7]\n"
    #     . "<b>high</b>:    $quote[6]\n"
    #     . "<b>volume</b>:  " . pedbot_commify($quote[8]);
}1;