###############################################################################
# pedbot_command_mlist
#
# synopsis:  print a list of awaiting messages.
# arguments: none.
# returns:   message list.

$COMMANDS{mlist} = "print a list of your awaiting messages."; 

sub pedbot_command_mlist {
    my $from = shift;
    
    my $user = $aim->normalize($from);
    
    # if there are no messages for the user let him know.
    return "you have no messages." if (!$message_queue{$user});
    
    # retrieve the list.
    my $recipient = $user;
    my $sql_query = "SELECT sender, timestamp FROM messages "
                  . "WHERE recipient = '$recipient' "
                  . "ORDER BY timestamp ASC";
    
    my $dbquery = $dbhandle->prepare($sql_query);
       $dbquery->execute;

    # initialize the message list.
    my $message_list = "<b>you have the following awaiting messages</b>:\n";
    
    # step through the list.
    for (my $i = 1; my $result = $dbquery->fetchrow_hashref; $i++) {
        # construct the timestamp
        my $time      = localtime($result->{timestamp});
        my $timestamp = sprintf("%02d.%02d.%d %02d:%02d:",
                            $time->mon + 1,
                            $time->mday,
                            $time->year + 1900,
                            $time->hour,
                            $time->min);
                            
        # add the message to the list.
        $message_list .= "[$i] $timestamp $result->{sender}\n";
    }
    
    $dbquery->finish;
    
    return $message_list;
}1;